<!DOCTYPE html>
<html>
<head>
    <title>Guest Book Form (Admin)</title>
    <meta charset="UTF-8">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png">
    <style>
        body {
            background: url("<?= base_url('asset/img/log.jpg') ?>") no-repeat center center fixed;
            background-size: cover;
            font-family: 'Poppins', sans-serif; /* Changed font for a modern feel */
            padding: 30px;
            min-height: 100vh;
            display: flex;
            align-items: center; /* Ensuring the card is vertically centered */
            position: relative;
        }
        /* Dark Overlay */
        body::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.4); /* Overlay for better text contrast */
            z-index: -1;
        }
        .card {
            background: rgba(255,255,255,0.98); /* More solid */
            border-radius: 16px;
            box-shadow: 0px 15px 30px rgba(0,0,0,0.4);
            animation: fadeInUp 0.8s ease;
            max-width: 550px; /* Optimal width for the form */
            width: 100%;
            margin-top: 20px;
            margin-bottom: 20px;
        }
        @keyframes fadeInUp {
            from {opacity: 0; transform: translateY(40px);}
            to {opacity: 1; transform: translateY(0);}
        }
        .card-header-custom {
            background: linear-gradient(135deg, #0d6efd, #0dcaf0); /* Subtle gradient */
            color: white;
            border-top-left-radius: 16px;
            border-top-right-radius: 16px;
            padding: 20px;
        }
        .form-label {
            font-weight: 600;
            color: #343a40;
        }
        .form-control, .form-control:focus {
            border-radius: 8px;
            border-color: #ced4da;
            box-shadow: none !important;
        }
        .btn {
            border-radius: 50px; /* Pill-shaped button */
            padding: 10px 25px;
            font-weight: 600;
        }
        
    </style>
</head>
<body>

<div class="container">
    <div class="card shadow-lg border-0">
        <div class="card-header-custom text-center">
            <h3 class="mb-0"><i class="bi bi-journal-check me-2"></i> Guest Entry Form</h3>
            <p class="mb-0 text-light opacity-75">Guest Registration Form by Admin</p>
        </div>
        
        <div class="card-body p-4 p-md-5">
            <form id="formTamuAdmin">
                <input type="hidden" 
                        name="<?= $this->security->get_csrf_token_name(); ?>" 
                        value="<?= $this->security->get_csrf_hash(); ?>">

                <h5 class="text-primary mb-3 pb-2 border-bottom"><i class="bi bi-person me-2"></i> Guest Identity Data</h5>
                
                <div class="mb-3">
                    <label for="nama" class="form-label">Full Name <span class="text-danger"></span></label>
                    <input type="text" id="nama" name="nama" class="form-control" placeholder="Guest's full name" required>
                </div>

                <div class="mb-3">
                    <label for="instansi" class="form-label">Institution/Company</label>
                    <input type="text" id="instansi" name="instansi" class="form-control" placeholder="Origin institution or company">
                </div>
                <div class="mb-3">
                    <label for="no_handphone" class="form-label">Phone Number <span class="text-danger"></span></label>
                    <input type="text" id="no_handphone" name="no_handphone" class="form-control"
                        placeholder="Guest's phone number" required>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="no_visitor" class="form-label">Visitor ID (ASI)</label>
                        <input type="text" id="no_visitor" name="no_visitor" class="form-control" placeholder="Visitor ID">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="no_tamu" class="form-label">Visitor Number (ARK)</label>
                        <input type="text" id="no_tamu" name="no_tamu" 
                                class="form-control" placeholder="Visitor ID"
                                value="<?= isset($no_tamu) ? $no_tamu : '' ?>" 
                                >
                    </div>
                </div>

                <h5 class="text-primary mt-4 mb-3 pb-2 border-bottom"><i class="bi bi-geo-alt me-2"></i> Visit Details</h5>
                
                <div class="mb-3">
                    <label for="keperluan" class="form-label">Purpose of Visit</label>
                    <textarea id="keperluan" name="keperluan" class="form-control" rows="3" placeholder="Brief purpose of the visit"></textarea>
                </div>

                <div class="mb-4">
                    <label for="waktu_masuk" class="form-label">Entry Time <span class="text-danger">*</span></label>
                    <input type="time" id="waktu_masuk" name="waktu_masuk" class="form-control" required>
                </div>
                <div class="mb-3 mt-3">
                    <label for="location" class="form-label"><i class="fa fa-map-marker-alt me-1"></i> Location</label>
                    <select id="location" name="location" class="form-select" required>
                        <option value="">-- Select Location --</option>
                        <option value="Arkadia Head Office">Arkadia Head Office</option>
                        <option value="Workshop BSD">Workshop BSD</option>
                    </select>
                </div>

                <div class="d-flex justify-content-center gap-3 pt-3">
                    <button type="submit" class="btn btn-success shadow-sm">
                        <i class="bi bi-save me-1"></i> Save Data
                    </button>
                    <a href="<?= site_url('tamu') ?>" class="btn btn-secondary shadow-sm">
                        <i class="bi bi-arrow-left me-1"></i> Back
                    </a>
                </div>

            </form>
        </div>
    </div>
</div>

<script>
$(document).ready(function(){
    $('#formTamuAdmin').on('submit', function(e){
        e.preventDefault();

        $.ajax({
            url: "<?= site_url('Tamu_controller/simpan_ajax') ?>",
            type: "POST",
            data: $(this).serialize(),
            dataType: "json",
            success: function(res){
                if(res.status === 'success'){
                    Swal.fire({
                        icon: 'success',
                        title: 'Success', // Terjemahan: Sukses
                        text: res.message,
                        confirmButtonColor: '#198754' // Success color
                    }).then(() => {
                        window.location.href = "<?= site_url('tamu') ?>"; // Redirect to guest page
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Failed', // Terjemahan: Gagal
                        text: res.message,
                        confirmButtonColor: '#dc3545' // Danger color
                    });
                }
            },
            error: function(xhr){
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'An error occurred on the server: ' + xhr.statusText, // Terjemahan: Terjadi kesalahan pada server:
                    confirmButtonColor: '#dc3545'
                });
            }
        });
    });
    
    // Set entry time automatically when the page loads
    $('#waktu_masuk').val(new Date().toTimeString().split(' ')[0].substring(0, 5));
});
</script>

</body>
</html>