<!DOCTYPE html>
<html>
<head>
    <title><?= isset($tamu) && $tamu ? 'Edit' : 'Tambah' ?> Tamu</title>
    <meta charset="UTF-8">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png">
    <style>
        body {
            background-color: #f4f7f9; /* Latar belakang lebih netral */
            font-family: 'Poppins', sans-serif;
            padding-top: 50px;
            padding-bottom: 50px;
        }
        .card-custom {
            max-width: 800px;
            margin: auto;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.15);
        }
        .card-header-custom {
            /* Gradient yang elegan dan terarah */
            background: linear-gradient(45deg, #0d6efd, #0dcaf0); 
            color: white;
            font-weight: 700;
            font-size: 1.5rem;
            border-top-left-radius: 20px;
            border-top-right-radius: 20px;
            padding: 25px;
        }
        .form-label {
            font-weight: 600;
            color: #343a40;
        }
        .form-control {
            border-radius: 10px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.08) !important;
            transition: border-color 0.3s;
        }
        .form-control:focus {
            border-color: #0d6efd;
        }
        .btn-gradient-submit {
            background: linear-gradient(90deg, #198754, #20c997);
            color: white;
            font-weight: 600;
            border: none;
            border-radius: 12px;
            min-width: 180px;
            padding: 10px 20px;
            transition: all 0.3s ease;
        }
        .btn-gradient-submit:hover {
            background: linear-gradient(90deg, #20c997, #198754);
            transform: translateY(-2px);
            box-shadow: 0 4px 10px rgba(32, 201, 151, 0.5);
        }
        .btn-secondary-custom {
            border-radius: 12px;
            min-width: 120px;
            font-weight: 500;
        }
        .form-section-title {
            font-size: 1.1rem;
            color: #0d6efd;
            font-weight: 600;
            margin-bottom: 20px;
            padding-bottom: 5px;
            border-bottom: 1px dashed #ced4da;
        }
    </style>
</head>
<body class="container">

<div class="card card-custom border-0">
    
    <div class="card-header-custom text-center">
        <?php if (isset($tamu) && $tamu): ?>
            <i class="bi bi-pencil-square me-2"></i> EDIT DATA TAMU
        <?php else: ?>
            <i class="bi bi-person-plus-fill me-2"></i> TAMBAH TAMU BARU
        <?php endif; ?>
    </div>

    <div class="card-body p-4 p-md-5">

        <form id="tamuForm" method="post" 
              action="<?= isset($tamu) && $tamu ? site_url('tamu_controller/update_user/'.$tamu->id) 
                                             : site_url('tamu_controller/simpan_user') ?>">

            <div class="form-section-title"><i class="bi bi-person me-2"></i> Data Identitas</div>
            <div class="row g-3 mb-4">
                <div class="col-md-6">
                    <label class="form-label"><i class="bi bi-person me-1"></i> Nama Lengkap</label>
                    <input type="text" name="nama" class="form-control" placeholder="Masukkan nama"
                            value="<?= isset($tamu) ? $tamu->nama : '' ?>" required>
                </div>
                <div class="col-md-6">
                    <label class="form-label"><i class="bi bi-building me-1"></i> Instansi/Perusahaan</label>
                    <input type="text" name="instansi" class="form-control" placeholder="Asal instansi"
                            value="<?= isset($tamu) ? $tamu->instansi : '' ?>" required>
                </div>
                <div class="col-md-6">
                    <label class="form-label"><i class="bi bi-tag me-1"></i> No Visitor (ASI)</label>
                    <input type="text" name="no_visitor" class="form-control" placeholder="No Urut Tamu"
                            value="<?= isset($tamu) ? $tamu->no_visitor : '' ?>" required>
                </div>
                <div class="col-md-6">
                    <label class="form-label"><i class="bi bi-hash me-1"></i> No Visitor (ARK)</label>
                    <input type="text" name="no_tamu" class="form-control" placeholder="ID Visitor"
                            value="<?= isset($tamu) ? $tamu->no_tamu : '' ?>" required>
                </div>
            </div>

            <div class="form-section-title"><i class="bi bi-clock-history me-2"></i> Detail Kunjungan</div>
            <div class="row g-3">
                <div class="col-12 mb-3">
                    <label class="form-label"><i class="bi bi-file-earmark-text me-1"></i> Keperluan</label>
                    <textarea name="keperluan" class="form-control" rows="3" placeholder="Tujuan kunjungan" required><?= isset($tamu) ? $tamu->keperluan : '' ?></textarea>
                </div>
                <div class="col-md-6">
                    <label class="form-label"><i class="bi bi-arrow-down-right-circle me-1"></i> Waktu Masuk</label>
                    <input type="time" name="waktu_masuk" class="form-control"
                            value="<?= isset($tamu) ? $tamu->waktu_masuk : '' ?>" required>
                </div>
                <div class="mb-3 mt-3">
                <label for="location" class="form-label"><i class="fa fa-map-marker-alt me-1"></i> Location</label>
                <select id="location" name="location" class="form-select" required>
                    <option value="">-- Select Location --</option>
                    <option value="Arkadia Head Office">Arkadia Head Office</option>
                    <option value="Workshop BSD">Workshop BSD</option>
                </select>
            </div>
                <div class="col-md-6">
                    <label class="form-label"><i class="bi bi-arrow-up-left-circle me-1"></i> Waktu Keluar</label>
                    <input type="time" name="waktu_keluar" class="form-control"
                            value="<?= isset($tamu) ? $tamu->waktu_keluar : '' ?>">
                    <small class="text-muted">Kosongkan jika tamu belum keluar.</small>
                </div>
            </div>

            <div class="mt-5 d-flex justify-content-center gap-3">
                <a href="<?= site_url('tamu_controller') ?>" class="btn btn-secondary-custom shadow-sm">
                    <i class="bi bi-arrow-left me-1"></i> Kembali
                </a>
                <button type="submit" id="btnSubmit" class="btn btn-gradient-submit shadow">
                    <?php if (isset($tamu) && $tamu): ?>
                        <i class="bi bi-check-circle me-1"></i> Simpan Perubahan
                    <?php else: ?>
                        <i class="bi bi-save me-1"></i> Simpan Data
                    <?php endif; ?>
                </button>
            </div>
        </form>
    </div>
</div>

<script>
$(document).ready(function(){
    $('#tamuForm').on('submit', function(e){
        e.preventDefault();
        
        const isEdit = <?= isset($tamu) && $tamu ? 'true' : 'false' ?>;
        const titleText = isEdit ? 'Konfirmasi Perubahan?' : 'Simpan Data Tamu?';
        const confirmText = isEdit ? 'Ya, Update!' : 'Ya, Simpan!';

        Swal.fire({
            title: titleText,
            text: "Pastikan semua data sudah terisi dengan benar.",
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#198754', 
            cancelButtonColor: '#6c757d',
            confirmButtonText: confirmText,
            cancelButtonText: 'Batal'
        }).then((result) => {
            if (result.isConfirmed) {
                // Tampilkan loading saat proses submit
                Swal.fire({
                    title: 'Memproses...',
                    text: 'Mohon tunggu sebentar.',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });
                // Submit form
                this.submit();
            }
        });
    });

    // SweetAlert Flash Message
    <?php if(isset($this->session) && $this->session->flashdata('success')): ?>
    Swal.fire({
        icon: 'success',
        title: 'Sukses',
        text: "<?= $this->session->flashdata('success'); ?>",
        confirmButtonColor: '#198754'
    });
    <?php endif; ?>
    <?php if(isset($this->session) && $this->session->flashdata('error')): ?>
    Swal.fire({
        icon: 'error',
        title: 'Gagal',
        text: "<?= $this->session->flashdata('error'); ?>",
        confirmButtonColor: '#dc3545'
    });
    <?php endif; ?>
});
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>