<!DOCTYPE html>
<html lang="id">
<head>
    <title>Visiting Guest List</title>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css">
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png"> 

    <style>
        /* Perbesar huruf isi tabel biar sebanding sama kolom */
#tabelTamu th, 
#tabelTamu td {
    font-size: 20px !important;   /* sebelumnya 11-12 default */
    font-weight: 500;
} 

/* badge tanggal dibesarkan */
#tabelTamu td span {
    font-size: 13px !important;
}

/* tombol action sedikit lebih besar */
#tabelTamu .btn-action {
    font-size: 15px !important;
    padding: 8px 12px !important;
}

        :root {
            --primary-blue: #007bff;
            --secondary-green: #28a745;
            --bg-main: #f1f5f9;
        }
        .page-wrapper {
    min-height: 88vh; /* ini supaya panjang sampai hampir full layar laptop */
}
.table-area {
    min-height: 65vh; /* table area ikut memanjang */
}

        body {
            background-color: var(--bg-main);
            font-family: 'Inter', sans-serif;
        }
        .card-header-custom {
            background: linear-gradient(135deg, var(--primary-blue), #00c6ff);
            color: white;
            padding: 1.5rem;
            border-top-left-radius: 1rem;
            border-top-right-radius: 1rem;
        }
        .dataTables_wrapper .dataTables_paginate .pagination .page-item.active .page-link {
            background-color: var(--primary-blue) !important;
            border-color: var(--primary-blue) !important;
        }
        #tabelTamu thead th {
            background-color: #0069d9 !important;
            color: white !important;
            text-align: center !important;
        }
        /* Semua kolom rata tengah */
        #tabelTamu th, 
        #tabelTamu td {
            text-align: center !important;
            vertical-align: middle !important;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            padding-top: 0.5rem;
            padding-bottom: 0.5rem;
        }
       #tabelTamu {
    width: 100% !important;
    table-layout: auto !important;
}

        /* Lebar Kolom */
        #tabelTamu th:nth-child(1), #tabelTamu td:nth-child(1) { width: 1%; }
        #tabelTamu th:nth-child(2), #tabelTamu td:nth-child(2) { width: 10%; }
        #tabelTamu th:nth-child(3), #tabelTamu td:nth-child(3) { width: 10%; }
        #tabelTamu th:nth-child(4), #tabelTamu td:nth-child(4) { width: 4%; }
        #tabelTamu th:nth-child(5), #tabelTamu td:nth-child(5) { width: 4%; }
        #tabelTamu th:nth-child(6), #tabelTamu td:nth-child(6) { width: 10%; }
        #tabelTamu th:nth-child(7), #tabelTamu td:nth-child(7) { width: 9%; } /* Lokasi */
        #tabelTamu th:nth-child(8), #tabelTamu td:nth-child(8) { width: 7%; }
        #tabelTamu th:nth-child(9), #tabelTamu td:nth-child(9) { width: 6%; }
        #tabelTamu th:nth-child(10), #tabelTamu td:nth-child(10) { width: 7%; }
        #tabelTamu th:nth-child(11), #tabelTamu td:nth-child(11) { width: 10%; }

        #tabelTamu .btn-action {
            font-size: 0.75rem;
            padding: 0.25rem 0.4rem;
            line-height: 1;
        }
        .btn-tambah {
            background: linear-gradient(45deg, var(--secondary-green), #20c997);
            color: white;
            font-weight: 600;
            border-radius: 0.625rem;
            padding: 0.625rem 1.25rem;
            border: none;
            transition: all 0.3s ease;
        }
        .btn-tambah:hover {
            background: linear-gradient(45deg, #20c997, var(--secondary-green));
            box-shadow: 0 4px 8px rgba(40, 167, 69, 0.4);
        }
        /* bikin row tabel lebih tinggi jadi keliatan lebar kebawah juga */
#tabelTamu tbody tr td {
    padding-top: 14px !important;
    padding-bottom: 14px !important;
    height: 48px; /* ini yang bikin row lebih tinggi */
}
.table-area {
    min-height: 70vh;
}

    </style>
</head>
<body class="p-4 md:p-8">

<div class="w-full bg-white rounded-xl shadow-2xl overflow-hidden page-wrapper">


    <div class="card-header-custom flex justify-between items-center p-6 md:p-8">
        <h2 class="text-xl md:text-2xl font-bold flex items-center">
            <i class="fa-solid fa-clipboard-list me-3"></i> Visiting Guest List Report
        </h2>
    </div>

    <div class="p- md:p-8">
        <div class="flex flex-col md:flex-row justify-between items-center filter-controls mb-5 p-4 rounded-lg shadow-sm bg-gray-50 border border-gray-200">

    <div class="flex flex-wrap items-center gap-4"> 
        
        <div class="flex items-center gap-2">
            <label class="fw-bold text-gray-700 text-sm me-2 mb-0">📅 Date Filter:</label>
            <input type="date" id="startDate" class="form-control form-control-sm rounded-lg border-gray-300 w-auto">
            <span class="text-gray-600 mx-1">to</span>
            <input type="date" id="endDate" class="form-control form-control-sm rounded-lg border-gray-300 w-auto">
        </div>
        
        <div class="flex items-center gap-2">
            <label class="fw-bold text-gray-700 text-sm me-2 mb-0">📍 Location:</label>
            <select id="locationFilter" class="form-select form-select-sm rounded-lg border-gray-300 w-auto">
                <option value="">All Locations</option>
                <option value="Arkadia Head Office">Arkadia Head Office</option>
                <option value="Workshop BSD">Workshop BSD</option>
            </select>
        </div>

        <button id="resetAllFilter" class="btn btn-outline-secondary btn-sm rounded-lg d-flex align-items-center gap-1">
            <i class="fa-solid fa-rotate-right"></i> Reset Filter
        </button>
    </div>

    <div class="flex flex-wrap gap-2">
        <button id="btnExportExcel" class="btn btn-success btn-sm rounded-lg shadow-md d-flex align-items-center gap-1 px-3">
            <i class="fa-solid fa-file-excel"></i> Export Excel
        </button>
        <button id="btnExportPDF" class="btn btn-danger btn-sm rounded-lg shadow-md d-flex align-items-center gap-1 px-3">
            <i class="fa-solid fa-file-pdf"></i> Export PDF
        </button>
    </div>
</div>
        <div class="overflow-x-auto rounded-lg shadow-inner border border-gray-200 table-area">

            <table id="tabelTamu" class="table table-bordered table-hover table-striped w-full min-w-[1400px]">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Name</th>
                        <th>Company</th>
                        <th>No Handphone</th>
                        <th>ASI No</th>
                        <th>No Visitor</th>
                        <th>Purpose</th>
                        <th>Location</th> 
                        <th>Date</th>
                        <th>Time In</th>
                        <th>Time Out</th>
                        <th>Checkout by</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (isset($tamu) && is_array($tamu)): ?>
                        <?php $no=1; foreach($tamu as $row): ?>
                        <tr data-date="<?= date('Y-m-d', strtotime($row->created_at)) ?>">
                            <td><?= $no++ ?></td>
                            <td><?= htmlspecialchars($row->nama) ?></td>
                            <td><?= htmlspecialchars($row->instansi) ?></td>
                            <td><?= htmlspecialchars($row->no_handphone)?></td>
                            <td><?= htmlspecialchars($row->no_visitor) ?></td>
                            <td><?= htmlspecialchars($row->no_tamu) ?></td>
                            <td><?= htmlspecialchars($row->keperluan) ?></td>
                            <td><?= htmlspecialchars($row->location ?? '-') ?></td>
                            <td><span class="bg-gray-500 text-white font-semibold px-3 py-1 rounded-full text-xs shadow-sm"><?= date('d-m-Y', strtotime($row->created_at)) ?></span></td>
                            <td><?= htmlspecialchars($row->waktu_masuk) ?></td>
                            
                            <td>
                                <?php if(empty($row->waktu_keluar)): ?>
                                    <button class="btn btn-sm bg-yellow-500 text-white btn-action hover:bg-yellow-600" data-bs-toggle="modal" data-bs-target="#keluarModal<?= $row->id ?>">
                                        <i class="fa-solid fa-clock me-1"></i> Check Out
                                    </button>
                                    <div class="modal fade" id="keluarModal<?= $row->id ?>" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content rounded-lg shadow-xl">
                                                <div class="modal-header bg-yellow-500 text-white rounded-t-lg">
                                                    <h5 class="modal-title font-bold"><i class="fa-solid fa-person-walking-arrow-right me-1"></i> Input Exit Time - <?= htmlspecialchars($row->nama) ?></h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                </div>
                                                <form method="post" action="<?= site_url('tamu_controller/keluar/'.$row->id) ?>">
                                                    <div class="modal-body">
                                                        <label class="form-label font-bold text-gray-700">Exit Time</label>
                                                        <input type="time" name="waktu_keluar" id="exitTimeInput<?= $row->id ?>" class="form-control rounded-lg" required>
                                                        <!-- Hanya user yang checkout ini yang dikirim -->
                                                        <input type="hidden" name="checkout_by" value="<?= $this->session->userdata('nama_lengkap') ?? $this->session->userdata('username') ?>">
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary rounded-lg" data-bs-dismiss="modal">Cancel</button>
                                                        <button type="submit" class="btn btn-success bg-secondary-green rounded-lg">
                                                            <i class="fa-solid fa-check me-1"></i> Save
                                                        </button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <span class="bg-green-500 text-white font-semibold px-3 py-1 rounded-full text-xs shadow-sm"><?= htmlspecialchars($row->waktu_keluar) ?></span>
                                <?php endif; ?>
                            </td>
                            <td><?= htmlspecialchars($row->checkout_by ?? '') ?></td>
                            <td>
                                <div class="flex justify-center space-x-1">
                                    <a href="<?= site_url('tamu_controller/edit/'.$row->id) ?>" class="btn btn-warning btn-action"><i class="fa-solid fa-pen-to-square"></i> Edit</a>
                                    <a href="<?= site_url('tamu_controller/hapus/'.$row->id) ?>" class="btn btn-danger btn-action" onclick="return confirm('Are you sure you want to delete this data?')"><i class="fa-solid fa-trash-can"></i> Delete</a>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr><td colspan="13" class="py-4 text-gray-500 font-semibold">No guest data available.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
 
      

        <div class="mt-6 flex flex-col md:flex-row gap-3">
            <a href="<?= site_url('Tamu_controller/form_admin') ?>" class="btn btn-tambah shadow-lg">
                <i class="fa-solid fa-user-plus me-1"></i> Add New Guest
            </a>
            <a href="<?= site_url('dashboard/index') ?>" class="btn btn-secondary rounded-lg shadow-md">
                <i class="fa-solid fa-arrow-left me-1"></i> Back to Dashboard
            </a>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>

<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script> 
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>


<script>
$(document).ready(function () {
    // 1. Inisialisasi DataTables
    var table = $('#tabelTamu').DataTable({
        "pageLength": 10,
        "ordering": true,
        "columnDefs": [{ "orderable": false, "targets": [0, 10] }],
        "dom": 'lfrtipB', 
        "buttons": [
            // Cuma sisakan PDF disini, Excel akan di-handle oleh AJAX
            {
                extend: 'pdfHtml5',
                text: 'Export PDF',
                className: 'd-none',
                orientation: 'landscape',
                pageSize: 'A4',
                exportOptions: {
                    columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9] 
                }
            }
        ]
    });

    // 2. Logika Filter Global (Tanggal & Lokasi)
    $.fn.dataTable.ext.search.push(function(settings, data, dataIndex){
        var min = $('#startDate').val(), max = $('#endDate').val();
        var rowDate = $(table.row(dataIndex).node()).data('date');

        // Cek Filter Tanggal
        if(!rowDate || !((min === "" || rowDate >= min) && (max === "" || rowDate <= max))) {
            return false;
        }
        
        // Cek Filter Lokasi (Kolom index 6)
        var selectedLocation = $('#locationFilter').val();
        var rowLocation = data[7];

        // Jika filter lokasi "All Locations" (kosong) atau lokasi baris cocok dengan filter
        if (selectedLocation === "" || rowLocation.trim() === selectedLocation) {
            return true;
        }

        return false;
    });

    // 3. Pemicu DataTables.draw() saat filter berubah
    $('#startDate, #endDate, #locationFilter').on('change', function(){ 
        table.draw(); 
    });

    // 4. Reset Semua Filter
    $('#resetAllFilter').click(function () { 
        $('#startDate').val('');
        $('#endDate').val(''); 
        $('#locationFilter').val(''); // Reset lokasi
        table.search('').draw(); // Reset keyword DataTables dan terapkan filter
    });
    
    // 5. Menghubungkan tombol kustom ke fungsi EKSPOR BERBASIS PHP
    
    // LOGIKA UNTUK EXPORT EXCEL
    $('#btnExportExcel').on('click', function() {
        var tanggalDari = $('#startDate').val();
        var tanggalSampai = $('#endDate').val();
        var keyword = $('input[type="search"]').val(); // Ambil dari searchbox DataTables
        var location = $('#locationFilter').val(); // <--- Ambil nilai lokasi

        var url = "<?= site_url('tamu_controller/export_excel') ?>";
        url += "?tanggal_dari=" + tanggalDari;
        url += "&tanggal_sampai=" + tanggalSampai;
        url += "&keyword=" + keyword;
        url += "&location=" + location; // <--- Tambahkan ke URL
        
        window.location.href = url;
    });

    // LOGIKA UNTUK EXPORT PDF
    $('#btnExportPDF').on('click', function() {
        var tanggalDari = $('#startDate').val();
        var tanggalSampai = $('#endDate').val();
        var keyword = $('input[type="search"]').val(); 
        var location = $('#locationFilter').val(); // <--- Ambil nilai lokasi

        var url = "<?= site_url('tamu_controller/export_pdf') ?>";
        url += "?tanggal_dari=" + tanggalDari;
        url += "&tanggal_sampai=" + tanggalSampai;
        url += "&keyword=" + keyword; 
        url += "&location=" + location; // <--- Tambahkan ke URL
         
        window.open(url, '_blank'); 
    });

});
</script>
</body>
</html>