<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Guest Book Report - Asia Serv</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
    <link rel="icon" href="<?= base_url('asset/img/asiaserv-logo.png') ?>" type="image/png">

    <style>
        :root {
            --asi-primary: #1e3c72;
            --asi-danger: #d32f2f;
            --asi-success: #198754; 
            --asi-warning: #ffc107;
            --bg-main: #f4f6f9;
            --card-shadow: 0 4px 15px rgba(0,0,0,0.1);
        }

        body {
            background-color: var(--bg-main);
            font-family: 'Poppins', sans-serif;
            color: #343a40;
            padding-bottom: 50px;
        }

        .main-card {
            background-color: #fff;
            border-radius: 15px;
            box-shadow: var(--card-shadow);
            margin-top: 30px;
            border: none;
        }

        .card-header-custom {
            background-color: var(--asi-primary);
            color: #fff;
            padding: 25px 30px;
            border-radius: 15px 15px 0 0;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        h2 { margin: 0; font-weight: 700; }

        .toolbar-container {
            padding: 20px 30px;
            border-bottom: 1px solid #e9ecef;
            background-color: #fcfcfc;
        }

        .filters-group .form-control, .filters-group .btn {
            border-radius: 8px;
        }

        #tabelTamu thead th, 
        #tabelTamu tbody td {
            text-align: center !important;
            vertical-align: middle !important;
        }

        #tabelTamu thead th {
            background-color: var(--asi-primary) !important;
            color: white;
            font-weight: 600;
            font-size: 0.85rem;
            padding: 12px 8px;
        }

        #tabelTamu tbody td {
            font-size: 0.9rem;
            padding: 10px 8px;
        }

        #tabelTamu tbody tr:hover {
            background-color: #e3f2fd !important;
        }

        .btn-action-group .btn {
            border-radius: 6px;
            font-size: 0.8rem;
            padding: 6px 10px;
        }

        .badge-date { 
            background: var(--asi-primary) !important; 
            font-size: 0.75rem; 
            border-radius: 6px; 
            padding: 4px 8px;
        }

        .status-keluar-btn {
            background-color: var(--asi-warning);
            color: #343a40;
            border: none;
            font-weight: 600;
        }

        .status-keluar-btn:hover {
             background-color: #e0a800;
        }

        .badge-keluar-sudah {
            background-color: var(--asi-success) !important;
            color: white;
            font-weight: 600;
            padding: 6px 10px;
        }

        .card-footer {
            background: #f8f9fa;
            border-top: 1px solid #e9ecef;
            padding: 20px 30px;
            border-radius: 0 0 15px 15px;
        }
    </style>
</head>
<body class="container-fluid">

<div class="main-card">
    <div class="card-header-custom">
        <h2><i class="fa-solid fa-clipboard-list me-2"></i>Guest Book Report</h2>
        <a href="<?= site_url('tamu_controller/form_tamu_user') ?>" class="btn btn-success shadow-sm d-flex align-items-center fw-bold">
            <i class="fa-solid fa-plus me-1"></i> Add New Guest
        </a>
    </div>

    <div class="toolbar-container">
        <form method="get" action="<?= site_url('tamu_controller') ?>">
            <div class="row g-3 align-items-end filters-group">
                <div class="col-lg-2 col-md-12">
                    <label class="form-label text-muted small" for="tableSearch">Quick Search</label>
                    <input type="text" id="tableSearch" class="form-control shadow-sm" placeholder="Name, company, or purpose...">
                </div>
                
                <div class="col-lg-2 col-md-4">
                    <label class="form-label text-muted small">Location</label>
                    <select name="location" class="form-control shadow-sm">
                        <option value="">-- All Location --</option>
                        <option value="Arkadia Head Office" <?= ($this->input->get('location') == 'Arkadia Head Office') ? 'selected' : '' ?>>Arkadia Head Office</option>
                        <option value="Workshop BSD" <?= ($this->input->get('location') == 'Workshop BSD') ? 'selected' : '' ?>>Workshop BSD</option>
                    </select>
                </div>

                <div class="col-lg-2 col-md-4">
                    <label class="form-label text-muted small">From Date</label>
                    <input type="date" name="tanggal_dari" class="form-control shadow-sm" value="<?= $this->input->get('tanggal_dari') ?>">
                </div>
                
                <div class="col-lg-2 col-md-4">
                    <label class="form-label text-muted small">To Date</label>
                    <input type="date" name="tanggal_sampai" class="form-control shadow-sm" value="<?= $this->input->get('tanggal_sampai') ?>">
                </div>

                <div class="col-lg-4 col-md-12 d-flex gap-2">
                    <button type="submit" class="btn btn-primary shadow-sm fw-bold"><i class="fa-solid fa-filter me-1"></i> Filter Data</button>
                    <a href="<?= site_url('tamu_controller') ?>" class="btn btn-secondary shadow-sm" title="Reset Filter"><i class="fa-solid fa-rotate-right"></i></a>
                    
                    <a href="<?= site_url('tamu_controller/export_excel/?keyword=' . $this->input->get('keyword') . '&tanggal_dari=' . $this->input->get('tanggal_dari') . '&tanggal_sampai=' . $this->input->get('tanggal_sampai') . '&location=' . $this->input->get('location')) ?>" 
                        class="btn btn-outline-success shadow-sm d-inline-flex align-items-center" title="Export to Excel">
                        <i class="fa-solid fa-file-excel"></i>
                    </a>
                    <a href="<?= site_url('tamu_controller/export_pdf/?keyword=' . $this->input->get('keyword') . '&tanggal_dari=' . $this->input->get('tanggal_dari') . '&tanggal_sampai=' . $this->input->get('tanggal_sampai') . '&location=' . $this->input->get('location')) ?>" 
                        class="btn btn-outline-danger shadow-sm d-inline-flex align-items-center" title="Export to PDF">
                        <i class="fa-solid fa-file-pdf"></i>
                    </a>
                </div>
            </div>
        </form>
    </div>

    <div class="card-body p-0">
        <?php if (!empty($tamu)): ?>
        <div class="table-responsive">
            <table id="tabelTamu" class="table table-striped table-hover table-sm mb-0">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Name</th>
                        <th>Company</th>
                        <th>No Handphone</th>
                        <th>Visitor No (ASI)</th>
                        <th>No visitor</th>
                        <th>Purpose</th>
                        <th>Location</th>
                        <th>Date In</th> 
                        <th>Time In</th>
                        <th>Time Out</th>
                        <th>Checkout By</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                <?php $no = 1; foreach ($tamu as $row): ?>
                    <tr>
                        <td><?= $no++ ?></td>
                        <td><?= htmlspecialchars($row->nama) ?></td>
                        <td><?= htmlspecialchars($row->instansi) ?></td>
                        <td><?= htmlspecialchars($row->no_handphone)?></td>
                        <td><?= htmlspecialchars($row->no_visitor) ?></td>
                        <td><?= htmlspecialchars($row->no_tamu) ?></td>
                        <td><?= htmlspecialchars($row->keperluan) ?></td>
                        <td><?= htmlspecialchars($row->location) ?></td>
                        <td><span class="badge badge-date"><?= date('d-m-Y', strtotime($row->created_at)) ?></span></td>
                        <td><?= htmlspecialchars($row->waktu_masuk) ?></td> 
                        <td>
                            <?php if(empty($row->waktu_keluar)): ?>
                                <button class="btn btn-sm status-keluar-btn"
                                        data-bs-toggle="modal"
                                        data-bs-target="#keluarModal<?= $row->id ?>">
                                    <i class="fa-solid fa-clock me-1"></i> Check-Out
                                </button>

                                <div class="modal fade" id="keluarModal<?= $row->id ?>" tabindex="-1">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header bg-warning text-dark">
                                                <h5 class="modal-title fw-bold"><i class="fa-solid fa-clock"></i> Enter Exit Time</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                            </div>
                                            <form method="post" action="<?= site_url('tamu_controller/keluar/'.$row->id) ?>">
                                                <div class="modal-body text-center">
                                                    <p class="mb-3">Guest Name: <span class="fw-bold"><?= htmlspecialchars($row->nama) ?></span></p>
                                                    <div class="mb-3">
                                                        <label class="form-label fw-bold">Time Out</label>
                                                        <input type="time" name="waktu_keluar" class="form-control text-center" required>
                                                        <input type="hidden" name="checkout_by" value="<?= $this->session->userdata('nama_lengkap') ?? $this->session->userdata('username') ?>">
                                                    </div>
                                                </div>
                                                <div class="modal-footer justify-content-center">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                    <button type="submit" class="btn btn-success">
                                                        <i class="fa-solid fa-check me-1"></i> Save
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            <?php else: ?>
                                <span class="badge badge-keluar-sudah"><?= htmlspecialchars($row->waktu_keluar) ?></span>
                            <?php endif; ?>
                        </td>
                        <td><?= htmlspecialchars($row->checkout_by ?? '-') ?></td>
                        <td>
                            <div class="d-flex justify-content-center gap-1 btn-action-group">
                                <a href="<?= site_url('tamu_controller/edit/'.$row->id) ?>" class="btn btn-warning" title="Edit Data">
                                    <i class="fa-solid fa-pen-to-square"></i>
                                </a>
                                
                            </div> 
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
            <div class="alert alert-info m-4 text-center"><i class="fa-solid fa-info-circle me-2"></i> Guest data not found.</div>
        <?php endif; ?>
    </div>

    <div class="card-footer p-3">
    <div class="row align-items-center">
        <div class="col-md-6 mb-2 mb-md-0 d-flex justify-content-start">
            <a href="<?= site_url('dashboard/user') ?>" class="btn btn-secondary shadow-sm fw-bold">
                <i class="fa-solid fa-arrow-left me-1"></i> Back to Dashboard
            </a>
        </div>
        <div class="col-md-6 d-flex justify-content-end" id="pagination-wrapper">
            
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.all.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>

<script>
$(document).ready(function () {
    var table = $('#tabelTamu').DataTable({
        "pageLength": 12, 
        "lengthChange": false,
        "ordering": true,
        // Kita gunakan 'lrtip' agar DataTables menghasilkan elemen i (info) dan p (pagination)
        "dom": 'lrtip', 
        "language": {
            "paginate": {"previous": "Previous","next": "Next"},
            "info": "Showing _START_ to _END_ of _TOTAL_ entries",
            "zeroRecords": "No matching records found",
            "infoEmpty": "Showing 0 to 0 of 0 entries",
            "infoFiltered": "(filtered from _MAX_ total entries)"
        }
    });

    // --- LOGIKA PEMINDAHAN ELEMEN DataTables ---
    
    // 1. Dapatkan elemen info dan paginate yang sudah dibuat DataTables
    var infoElement = $('#tabelTamu_info');
    var paginateElement = $('#tabelTamu_paginate');

    // 2. Cek apakah elemen tersebut ada, jika ya, pindahkan.
    if (infoElement.length && paginateElement.length) {
        // Detach (ambil) elemen dari posisi aslinya
        infoElement.detach();
        paginateElement.detach();

        // Buat wrapper flexbox baru
        var wrapper = $('<div class="d-flex justify-content-end align-items-center gap-3 w-100"></div>');
        
        // Masukkan elemen Info dan Pagination ke wrapper
        wrapper.append(infoElement).append(paginateElement);

        // Sisipkan wrapper baru ke dalam col-md-6 di card-footer
        $('#pagination-wrapper').append(wrapper);

        // Opsional: Pastikan elemen DataTables yang tersembunyi sebelumnya (yaitu baris tempat Info dan Paginate
        // seharusnya muncul secara default) tidak menyebabkan masalah tata letak:
        $('.dataTables_wrapper .row:nth-child(2)').hide();
    }
    // --- AKHIR LOGIKA PEMINDAHAN ELEMEN ---

    // Fungsi pencarian
    $('#tableSearch').on('keyup', function () {
        table.search(this.value).draw();
    });

    // ... (Kode SweetAlert dan tombol Hapus)
    <?php if(isset($this->session) && $this->session->flashdata('success')): ?>
    Swal.fire({
        icon: 'success',
        title: 'Success!',
        text: "<?= $this->session->flashdata('success'); ?>",
        confirmButtonColor: '#3085d6', 
        timer: 3000
    });
    <?php endif; ?>
    
    document.querySelectorAll('.btnHapus').forEach(btn => {
        btn.addEventListener('click', function(e){
            e.preventDefault();
            const url = this.dataset.url;
            Swal.fire({
                title: 'Are you sure?',
                text: "The deleted data cannot be recovered!",
                icon: 'warning',
                showCancelButton: true, 
                confirmButtonColor: 'var(--asi-danger)',
                cancelButtonColor: 'var(--asi-primary)',
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = url;
                }
            });
        });
    });
});
</script>
</body>
</html>
